<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <title>Afficher la version choisie</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>

<?php
if (isset($_GET['version'])) {
    // Connexion à la base de données
    include ("connexion.php");

    // Requête préparée pour récupérer les informations de la version choisie
    $requete = "SELECT * FROM heptameron WHERE id = :id";
    $stmt = $db->prepare($requete);
    $stmt->bindValue(':id', $_GET['version'], PDO::PARAM_INT);
    $stmt->execute();

    // Récupération des données
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        // Afficher les informations de la version choisie
        echo "<h2>Version  {$result['id ']} de {$result['title']} ({$result['code']})</h2>";
        echo "<p>Type : {$result['type']}</p>";
        echo "<p>Version publiée en {$result['year']}</p>";
        echo "<p>Le titre de cette version est {$result['title']}</p>";
        echo "<p>Localisation de l'exemplaire: {$result['location']}</p>";
        echo "<p>Publié par {$result['publisher']} à {$result['publisherCity']}</p>";
        echo "<p> Édité par {$result['editor']}</p>";
        echo "<iframe src=\"{$result['url']}\" width=300 height=500>";
        // Ajouter ici toutes les informations supplémentaires que tu veux afficher
    } else {
        echo "<p>Aucune version trouvée pour l'ID spécifié.</p>";
    }
} else {
    echo "<p>Veuillez choisir une version.</p>";
}
?>

</body>
</html>
